package com.coll.voicechanger

import android.Manifest
import android.content.pm.PackageManager
import android.os.Bundle
import android.widget.ArrayAdapter
import androidx.appcompat.app.AppCompatActivity
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat
import android.widget.Button
import android.widget.SeekBar
import android.widget.Spinner

class MainActivity : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)

        val btnPerm = findViewById<Button>(R.id.btnRequestPerm)
        val btnCall = findViewById<Button>(R.id.btnStartCall)
        val presetSpinner = findViewById<Spinner>(R.id.presetSpinner)
        val pitchSlider = findViewById<SeekBar>(R.id.pitchSlider)

        btnPerm.setOnClickListener {
            requestMicrophonePermission()
        }

        btnCall.setOnClickListener {
            // Placeholder: start VoIP call flow (requires signaling + WebRTC)
        }

        // Presets
        val presets = listOf("TeenGirl (Default)", "LightFemale", "Robot")
        presetSpinner.adapter = ArrayAdapter(this, android.R.layout.simple_spinner_item, presets)
        presetSpinner.setSelection(0)

        pitchSlider.progress = 10 // neutral center
    }

    private fun requestMicrophonePermission() {
        if (ContextCompat.checkSelfPermission(this, Manifest.permission.RECORD_AUDIO) != PackageManager.PERMISSION_GRANTED) {
            ActivityCompat.requestPermissions(this, arrayOf(Manifest.permission.RECORD_AUDIO), 1001)
        }
    }
}
